﻿
<%@ page language="c#" autoeventwireup="false" codepage="1200" %>

<%@ register tagprefix="ea" namespace="Soneta.Web" assembly="Soneta.Web" %>
<%@ register tagprefix="eb" namespace="Soneta.Core.Web" assembly="Soneta.Core.Web" %>

<%@ Import namespace="System.Linq" %>
<%@ Import namespace="System.Collections.Generic" %>

<%@ Import namespace="Soneta.Business" %>
<%@ Import namespace="Soneta.Kasa" %>
<%@ Import namespace="Soneta.Tools" %>
<%@ Import namespace="Soneta.Types" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Raport rozliczeń zbiorczy</title>

	<script runat="server">
		

		private OdsetkiKarneParams pars = null;
		private RozliczenieSP.InfoDRWorker drWorker = null;
		private OdsetkiKarneCalcInfo odsInfo = null;
		private Currency odsetkiTotal = Currency.Zero;


		[Context(Required = true)]
		public OdsetkiKarneParams Params
		{ set { pars = value; } } 

		[Context(Required = true)]
		public Row[] CtxRow { get; set; }


		void OnContextLoad(Object sender, EventArgs args)
		{
		    drWorker = new RozliczenieSP.InfoDRWorker();
			odsInfo = OdsetkiKarneCalcInfo.CreateInstance(pars);
		
			List<IRozliczalny> documents = new List<IRozliczalny>();

			foreach (IRozliczalny row in CtxRow.Cast<IRozliczalny>())
				if (row.KwotaRozliczona > Currency.Zero)
					documents.Add(row);

			if (documents.Count == 0)
				throw new ApplicationException("Nie wybrano żadnych płatności lub zapłat posiadających rozliczenia.");

			ReportHeader["ODSETKI"] = pars.Description;
			DokRepeater.DataSource = documents;			
		}


		private void BeforeDocument(Object sender, EventArgs args)
		{
			IRozliczalny document = (IRozliczalny)DokRepeater.CurrentRow;

			IdDataRozliczenia.EditValue = document.DataRozliczenia == Date.MaxValue ? "(nie rozliczony)" : document.DataRozliczenia.ToString();
			IdTermin.EditValue = document is Platnosc ? ((Platnosc)document).Termin.ToString() : "(brak)";

			drWorker.Dokument = document;
			GridRozliczenia.DataSource = document.Rozliczenia;
		}


		private void BeforeRozliczenie(Object sender, RowEventArgs args)
		{
			drWorker.RozliczenieSP = (RozliczenieSP)args.Row;

			CmDataDokumentu.EditValue = drWorker.Rozliczenie.DataDokumentu;
			CmNumerDokumentu.EditValue = drWorker.Rozliczenie.NumerDokumentu;		
			CmKwotaDokumentu.EditValue = drWorker.KwotaDokumentu;
			CmKwotaRozliczenia.EditValue = drWorker.KwotaRozliczenia;

			if (drWorker.Dokument is Platnosc)
			{
				if (drWorker.RozliczenieSP.Data > drWorker.Dokument.TerminPlatnosci)
				{
					int zwlokaDni = drWorker.RozliczenieSP.Data - drWorker.Dokument.TerminPlatnosci;

					IdZwloka.EditValue = zwlokaDni;

					Currency odsetki = PoliczOdsetki(zwlokaDni);
					IdOdsetki.EditValue = odsetki;

					if (odsetki > Currency.Zero)
						if (odsetkiTotal == Currency.Zero)
							odsetkiTotal = odsetki;
						else if (odsetkiTotal.Symbol == odsetki.Symbol)
							odsetkiTotal += odsetki;
						else odsetkiTotal = Currency.Multi;

					IdOdsetkiTotal.EditValue = odsetkiTotal;
				}
			}
		}


		private Currency PoliczOdsetki(int zwlokaDni)
		{
			if (zwlokaDni > 0)
			{
				odsInfo.SetPodmiot(drWorker.Dokument.Podmiot);
				return OdsetkiKalkulator.ObliczCalkowiteOdsetki(drWorker.RozliczenieSP, odsInfo);
			}

			return new Currency(0.0, drWorker.KwotaRozliczenia.Symbol);
		}


		private void OdsetkiPreRender(object obj, EventArgs args)
		{
			IdOdsetkiTotal.EditValue = odsetkiTotal;
		}

		
	</script>

</head>
<body>
	<form id="Form1" method="post" runat="server">

		<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" />
		<eb:reportheader id="ReportHeader" runat="server" title="Raport rozliczeń zbiorczy|</strong>Dokumenty: <strong>wg zaznaczenia na liście|</strong>Odsetki: <strong>%ODSETKI%" />

		<ea:datarepeater id="DokRepeater" runat="server" onbeforerow="BeforeDocument">
		<table style="font-size:9pt;margin-top:10pt;" width="100%">
			<tr>
				<td style="text-align:right;">Dokument:</td>
				<td><ea:DataLabel runat="server" ID="DataLabel1" DataMember="NumerDokumentu" EncodeHTML="True" /></td>
				<td style="text-align:right;">Data:</td>
				<td><ea:DataLabel runat="server" ID="DataLabel2" DataMember="DataDokumentu" EncodeHTML="True" /></td>
				<td style="text-align:right;">Podmiot:</td>
				<td colspan="3"><ea:DataLabel runat="server" ID="DataLabel3" DataMember="Podmiot" EncodeHTML="True" /></td>
			</tr>
			<tr>
				<td style="text-align:right;">Kwota:</td>
				<td><ea:DataLabel runat="server" ID="DataLabel4" DataMember="Kwota" EncodeHTML="True" /></td>
				<td style="text-align:right;">Data rozliczenia:</td>
				<td><ea:DataLabel runat="server" ID="IdDataRozliczenia" EncodeHTML="True"/></td>
				<td style="text-align:right;">Do rozliczenia:</td>
				<td><ea:DataLabel runat="server" ID="DataLabel6" DataMember="DoRozliczenia" EncodeHTML="True" /></td>
				<td style="text-align:right;">Termin:</td>
				<td><ea:DataLabel runat="server" ID="IdTermin" /></td>
			</tr>
		</table>

		<ea:Grid runat="server" RowTypeName="Soneta.Kasa.RozliczenieSP,Soneta.Kasa" ID="GridRozliczenia" OnBeforeRow="BeforeRozliczenie" >
			<Columns>
				<ea:GridColumn ID="GridColumn1" runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." />
				<ea:GridColumn ID="CmDataDokumentu" runat="server" Width="12" Align="Center" Caption="Data" EncodeHTML="True" />
				<ea:GridColumn ID="CmNumerDokumentu" runat="server" Align="Left" Caption="Numer"  EncodeHTML="True" />
				<ea:GridColumn ID="CmKwotaDokumentu" runat="server" Width="16" Align="Right" Total="Sum" Caption="Kwota" EncodeHTML="True" />
				<ea:GridColumn ID="CmKwotaRozliczenia" runat="server" Width="16" Align="Right" Caption="Rozliczenie" HideZero="True" EncodeHTML="True" />
				<ea:GridColumn ID="IdZwloka" runat="server" Width="10" Align="Right" Caption="Zwłoka" EncodeHTML="True"  />
				<ea:GridColumn ID="IdOdsetki" runat="server" Width="16" Align="Right" Caption="Odsetki" Total="Sum" EncodeHTML="True" />
			</Columns>
		</ea:Grid>
	</ea:datarepeater>

		<div style="margin-top: 10pt; margin-bottom: 10pt;">
			Całkowita wartość odsetek:
			<ea:datalabel runat="server" id="IdOdsetkiTotal" EncodeHTML="True" />
		</div>

		<eb:reportfooter id="ReportFooter" runat="server" />

	</form>
</body>
</html>

